#ifndef __IActionListener__
#define __IActionListener__

#include "../Events/CActionEvent.hpp"
using Exponent::GUI::Events::CActionEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IActionListener IActionListener.hpp
			 * @brief Allows for responding to control events
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IActionListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IActionListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IActionListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IActionListener() { }

//	===========================================================================

				/**
				 * Handle an event - a control has changed in some way and wants you\n
				 * to update the internal workings accordingly
				 * @param event The event to hande
				 */
				virtual void handleActionEvent(const CActionEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IActionListener.hpp